@echo off
::
::  This batch file compiles a Windows NT console verion
::  of the EXAMPLE program, using the Visual C++ 4.2
::  compiler.
::
::  It assumes the directory trees of both the compiler
::  and CSLIB haven't been changed from their defaults.
::


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::: Do some drive mappings   :::::::::::::::::::::::::::::::::::::::::::
::: THIS HAS TO BE EDITED!!  :::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


::: Make drive 'J' points to the root directory of Visual C++ 4.2 :::::
REM  EDIT THIS LINE!
subst j: c:\usr\msvc42

::: Make drive 'K' points to the root directory of CSLIB :::::::::::::::
REM  EDIT THIS LINE!
subst k: e:\cslib


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::: Sanity checks ::::::::::::::::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::


if exist j:\bin\cl.exe goto check2
echo.
echo ERROR: Drive 'J' doesn't seem to point to the VC 4.2 directory.
echo Please edit VC42.BAT.
echo.
goto done

:check2
if exist k:\lib\vc42\csmnfe.lib goto ok
echo.
echo ERROR: Drive 'K' doesn't seem to point to the CSLIB directory.
echo Please edit VC42.BAT.
echo.
goto done



::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::: Compiler Options and Configuration :::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:OK



set SOURCE1=example

echo %SOURCE1%.cpp		 >comp.ind

:: Packing is important, but CSLIB uses the
:: compiler default which is 4 bytes with
:: 32 bits executables.
::
:: Packing can be controlled by the /Zp[n]
:: option.

echo /O2 /G3 /c /nologo 	>>comp.ind
echo /Ij:\include		>>comp.ind
echo /Ik:\include		>>comp.ind


REM Compiling.........
j:\bin\cl   @comp.ind

echo /SUBSYSTEM:CONSOLE 	 >link.ind
echo %SOURCE1%.obj		>>link.ind
echo /OUT:%SOURCE1%.exe 	>>link.ind
echo /LIBPATH:j:\lib		>>link.ind
echo /LIBPATH:k:\lib\vc42	>>link.ind
echo.				>>link.ind

echo kernel32.lib		>>link.ind
echo user32.lib 		>>link.ind
echo gdi32.lib			>>link.ind
echo comdlg32.lib		>>link.ind
echo advapi32.lib		>>link.ind
echo shell32.lib		>>link.ind

echo csmnfe.lib 		>>link.ind


REM Linking...........
j:\bin\link  @link.ind


::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::: Un-substituting the drives :::::::::::::::::::::::::::::::::::::::::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:done

subst k: /D >null
subst j: /D >null


